% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lam_est.R
\name{lam_est}
\alias{lam_est}
\title{Determine the value of the parameter \eqn{\lambda} for multiple competion.}
\usage{
lam_est(obs_scores_pvals, d, q)
}
\arguments{
\item{obs_scores_pvals}{Vector of p-values for the observed scores. Low p-values correspond to more evidence against the null.}

\item{d}{The number of competing scores for each hypothesis.}

\item{q}{The significance level we perform the binomial test at. This test determines whether we classify the p-values as 'evenly distributed'.}
}
\value{
\item{lam}{The selected value of \eqn{\lambda}.}
}
\description{
Determines the value of \eqn{\lambda} for use in multiple competition. This value is obtained by tabulating the p-values and
sequentially using a binomial test to find the point at which the remaining number of p-values to the right are evenly distributed around their mid-point.
For more details see section 3.6 and supplementary section 6.3 in the accompanying paper.
}
\references{
Emery K, Keich U, Hasam S and Nobel W. (2019) Multiple competition based FDR control. arXiv:1907.01458\cr
\url{https://arxiv.org/abs/1907.01458}
}
\author{
Kristen Emery
}
