#######################################################################
##  SPECHT 2.4 - init.g : Specht initialization                      ##
##                                                                   ##
##     A GAP package for calculating the decomposition numbers of    ##
##     Hecke algebras of type A (over fields of characteristic       ##
##     zero). The functions provided are primarily combinatorial in  ##
##     nature. Many of the combinatorial tools from the (modular)    ##
##     representation theory of the symmetric groups appear in the   ##
##     package.                                                      ##
##                                                                   ##
##     These programs, and the enclosed libraries, are distributed   ##
##     under the usual licensing agreements and conditions of GAP.   ##
##                                                                   ##
##     Andrew Mathas          mathas@maths.usyd.edu.au               ##
##     University of Sydney   Sydney, 1997                           ##
##                                                                   ##
##        Version 2.4:  October   1997  University of Sydney         ##
##        Version 2.3:  December  1996  Imperial College             ##
##        Version 2.2:  June      1996  Imperial College             ##
##        Version 2.1:  April     1996  Imperial College             ##
##        Version 2.0:  March     1996  Imperial College             ##
##        Version 1.0:  September 1995  Imperial College             ##
##                                                                   ##
#######################################################################

## Change log

## 2.4:
##   - replaced SPECHTHOME, SPECHTVERSION etc with SPECHT.Home,
##     SPECHT.Version etc.
##
## 2.2: June 1996: various changes requested by the referee.
##   - moved handling functions into induce.g and deleted SpechtParts.
##   - changed various function names
##
## 2.1: April 1996:
##  - Changed LabelPartition so that it no longer generates all
##    partitions of n when the given a 'new' partition.
##  - Fixed typo in AUTO command for IsSpecht in init.g.
##
## 2.0: March 1996: 
##   - broke specht.g up into smaller files and added AUTO commands.
##     The component files of Specht are now:
##       init.g:     general handling functions (this file).
##       specht.g:   functions which are heavily dependent upon
##                   Specht() and Schur() records, or decomposition
##                   matrices. In particular this file contains the
##                   functions Specht, Schur, and all decomposition
##                   matrix routines.
##       symmcomb.g: functions for combinatorics on Young diagrams and
##                   partitions (combinatorics of ths symmetric groups).
##       tableaux.g: operations on (semistandard) tableaux.
##       tex.g:      TeX() functions (this really should be moved into
##                   the GAP library).
##   - added Specialized() function.
##   - added SpechtParts() giving streamlined access to partitions and
##     associated strings.
##   - default decomposition matrix libraries reduced to those that 
##     Specht is unable to calculate using LLT. 
##   - added tex.g library to allow easy TeXing of (crystallized)
##     decomposition matrices with polynomial entries.
##   - put tableaux functions into tableaux.g
##   - added opening message
##
## 1.0: December 1995: initial release.

###########################################################################

if not QUIET and BANNER  then
  Print("\n\n------------------------------------------------------",
        "\nSPECHT 2.4                                October 1997",
        "\n    A package for calculating decomposition numbers of",
        "\n    Hecke algebras of the symmetric groups and q-Schur",
        "\n    algebras.\n",
        "\n(C) Andrew Mathas  mathas@maths.usyd.edu.au     Sydney",
        "\n------------------------------------------------------",
        "\n\n");
fi;

###########################################################################

SPECHT:=rec(Home:=Concatenation(LOADED_PACKAGES.specht,"gap/"),
            Library:=Concatenation(LOADED_PACKAGES.specht,"lib/"),
            Version:="version 2.4, (C) Andrew Mathas 1997.",
            Email:="mathas@maths.usyd.edu.au"
);

#######################################################################

ReadSpecht:=function(name)
   if not ReadPath(SPECHT.Home, name, ".g", "ReadSpecht") then
      Error("SPECHT library file '", name, "' must exist and be readable");
  fi;
end;

###########################################################################

AUTO( ReadSpecht( "specht" ),
  Specht, Schur, IsSpecht, IsDecompositionMatrix, SimpleDimension,
  ListERegulars, ERegulars, SplitECores, IsSimpleModule, Schaper, 
  SchaperMatrix, MullineuxMap, DecompositionNumber, Obstructions,
  IsNewIndecomposable, AddIndecomposable, RemoveIndecomposable, 
  MissingIndecomposables, DecompositionMatrix, CrystalDecompositionMatrix,
  InvertDecompositionMatrix, SaveDecompositionMatrix, AdjustmentMatrix,
  MatrixDecompositionMatrix, DecompositionMatrixMatrix,
  InducedDecompositionMatrix, CalculateDecompositionMatrix );

AUTO( ReadSpecht( "induce" ),
  Specialized, InducedModule, SInducedModule, RestrictedModule, 
  SRestrictedModule, InnerProduct, Coefficient, PositiveCoefficients, 
  IntegralCoefficients, TightStringList, LabelPartition, StringPartition, 
  SpechtPrettyPrint, SpechtPrintFn );

AUTO( ReadSpecht( "symmcomb" ),
  Lexicographic, LengthLexicographic, ReverseDominance, Dominates,
  ConjugatePartition, LittlewoodRichardsonRule,
  LittlewoodRichardsonCoefficient, InverseLittlewoodRichardsonRule,
  SpechtDimension, EAbacusRunners, ECore, IsECore, EWeight, EQuotient,
  EAbacus, EAbacusRunners, CombineEQuotientECore, IsERegular, 
  ERegularPartitions, EResidueDiagram, ETopLadder, EHookDiagram, 
  HookLengthDiagram, GoodNodes, GoodNodeSequence, GoodNodeSequences, 
  PartitionGoodNodeSequence, GoodNodeLatticePath, LatticePathGoodNodeSequence, 
  GoodNodeLatticePaths, RemoveRimHook, AddRimHook, BetaSet, PartitionBetaSet, 
  MullineuxSymbol, PartitionMullineuxSymbol, NormalNodes, RemoveNormalNodes );
   
AUTO( ReadSpecht( "tableaux" ),
  ConjugateTableau, IsSemiStandardTableau, SemiStandardTableaux,
  StandardTableaux, TypeTableau, ShapeTableau );

AUTO( ReadSpecht( "tex" ), 
  TeX, __TeXPolynomial, TeXPolynomial, TeXMatrix, TeXWideMatrix );
  
