/**
 * This class contains methods for storing and retrieving
 *	- parent node value
 *	- child node value
 *	- node type i.e. "LEAF" or "INTERNAL"
 *
 * @author Vivek Jayaswal
 *
 *	- Added code to return the child node number corresponding to a specified node
 */
public class NodeStructure {
	String nodeType;			//Leaf Node or Internal Node
	String parentNode;			//Link to the parent node
	String childNode1;			//Link to child node 1
	String childNode2;			//Link to child node 2
	int childNodeCount;			//Number of child node links created
	
	NodeStructure() {
		nodeType = null;
		parentNode = null;
		childNode1 = null;
		childNode2 = null;
		childNodeCount =0;
	}
	
	public String getNodeType() {
		return nodeType;
	}
	
	public String getParentNode() {
		return parentNode;
	}

	public String getChildNode1() {
		return childNode1;
	}
	
	public String getChildNode2() {
		return childNode2;
	}

	public int getChildNodeCount() {
		return childNodeCount;
	}
	
	public void setNodeType(String node) {
		nodeType = node;
	}
	
	public void setParentNode(String node) {
		parentNode = node;
	}
	
	public void setChildNode1(String node) {
		childNode1 = node;
	}

	public void setChildNode2(String node) {
		childNode2 = node;
	}
	
	public void setChildNodeCount(int count) {
		childNodeCount = count;
	}

	/* This method returns the value of the child node that is to be retained
	 *
	 *	@param node			Represents the child node to be removed
	 *
	 *	@return 			Child Node to be retained
	 */
	public String getSavedChildNode(String node) {
		
		if(childNode1.equals(node)) return childNode2;
		if(childNode2.equals(node)) return childNode1;
		
		System.out.println("Error Occured in method getSavedChildNode()");
		return "ERROR";
	}
	
	/*	This method is used to reconnect the parent of a given node N to the 
	 *	child node of N
	 *
	 *	@param	parenNode		Parent node of N
	 *	@param	childNode		Retained child node of N
	 */
	public void setChildNode(String parentNode, String childNode) {
		if((childNode1 != null) && 
			childNode1.equals(parentNode)) childNode1 = childNode;
		
		if((childNode2 != null) && 
			childNode2.equals(parentNode)) childNode2 = childNode;
				
		//else childNode2 = childNode;
	}
	
	/**	This method is used to change the node linked to an existing child node
	 *	or parent node
	 *
	 *	@param oldNode			Node linked to an existing child node
	 *	@param	newNode			New node to replace the "oldNode"	
	 */
	public void modifyNode(String oldNode, String newNode) {
		
		if(childNode1 != null && childNode1.equals(oldNode)) childNode1 = newNode;
		
		if(childNode2 != null && childNode2.equals(oldNode)) childNode2 = newNode;
		
		if(parentNode != null && parentNode.equals(oldNode)) parentNode = newNode; 
	}
	
	/**	This method is used to return the child node pointer to the user-specified
	 *	node
	 *
	 *	@param	prevNode			Node name
	 *
	 *	@return int					Child node number
	 */
	public int getChildNodeNumber(String prevNode) {
		if(childNode1.equals(prevNode)) return 0;
		
		return 1;
	}
}